scriptname FNIS_PCEA2PlayerLoad extends ReferenceAlias

FNIS_PCEA2QuestScript Property FNIS_PCEA2quest Auto

event OnPlayerLoadGame()
	bool ok = RequirementsAreMet()
;	FNIS_PCEA2quest.isStartOK = ok
	if !RequirementsAreMet()
		FNIS_PCEA2quest.isStartOK = false
		return
	endif

	Debug.Trace("FNIS PCEA2 Quest started (load)")

	int PCEA2crc = FNIS_PCEA2.GetCRCvalue()
	if ( PCEA2crc != FNIS_PCEA2quest.PCEA2crc )
		string[] SelectionName = FNIS_PCEA2.GetSubDirList()
		int i
		while ( i < 10 ) && ( i <= SelectionName.Length )
			if ( StringUtil.GetNthChar(SelectionName[i],1) == "_" )
				FNIS_PCEA2quest.isSelected[i] = true
			endif
			i += 1
		endwhile
		FNIS_PCEA2quest.PCEA2crc = PCEA2crc
		SendModEvent("PCEA2Task", "refresh")
	endif			
endEvent

bool Function RequirementsAreMet()
	bool isGenerated = FNIS.isGenerated()
	string VersionToString = FNIS.VersionToString()
	bool isVersionOK = (FNIS.VersionCompare( 6, 0, 0 ) >= 0)
	bool isFNISesp = (Game.GetModByName("FNIS.esp") < 255)
	bool isFNIS_PCEA2esp = (Game.GetModByName("FNIS_PCEA2.esp") < 255)
	bool isSKSE = (SKSE.GetVersionRelease() > 0)
	if ! (isGenerated && isVersionOK && isSKSE && isFNISesp && isFNIS_PCEA2esp)
		string out = "FNIS PCEA2 stopped with ERROR(s):"
		if ! isVersionOK
			out = out + "\n- FNIS version " + VersionToString + " older than required" 
		endif
		if ! isGenerated
			out = out + "\n- Last FNIS generation failed" 
		endif
		if ! isFNIS_PCEA2esp
			out = out + "\n- FNIS_PCEA2.esp not activated" 
		endif
		if ! isFNISesp
			out = out + "\n- FNIS.esp not activated" 
		endif
		if ! isSKSE
			out = out + "\n- SKSE not started" 
		endif
		Debug.Messagebox(out)
		Debug.Trace(out)
		return false
	endif
	return true
EndFunction
		